/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.builder;

import com.aptana.editor.php.internal.builder.AbstractBuildPathResource;
import com.aptana.editor.php.internal.core.builder.IBuildPath;
import com.aptana.editor.php.internal.core.builder.IModule;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;

public class LocalModule
extends AbstractBuildPathResource
implements IModule {
    private IFile file;

    public LocalModule(IFile file, IBuildPath buildPath) {
        super(buildPath, file.getFullPath() == null || file.getLocation() == null ? null : file.getLocation().toOSString());
        this.file = file;
    }

    public InputStream getContents() throws IOException {
        try {
            return this.file.getContents();
        }
        catch (CoreException e) {
            throw new IOException(e.getMessage());
        }
    }

    public IFile getFile() {
        return this.file;
    }

    @Override
    public String toString() {
        if (this.file == null) {
            return "null";
        }
        return this.file.getFullPath().toPortableString();
    }

    public String getShortName() {
        return this.file.getName();
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LocalModule other = (LocalModule)obj;
        return !(this.file == null ? other.file != null : !this.file.equals((Object)other.file));
    }

    public long getTimeStamp() {
        return this.file.getModificationStamp();
    }
}

